#include <bits/stdc++.h>

#include <ext/pb_ds/assoc_container.hpp>
#include <ext/pb_ds/tree_policy.hpp>

using namespace std;
using namespace __gnu_pbds;

#define int long long
#define sz(x) ((int) (x).size())
#define all(a) (a).begin(), (a).end()
#define rall(a) (a).begin(), (a).end()
#define ff first
#define ss second

using pii = pair<int, int>;

template<typename T, typename Cmp = less<T>>
using ordered_set =
        tree<T, null_type, Cmp, rb_tree_tag, tree_order_statistics_node_update>;

template<typename T>
void mnr(T &a, const T &b) {
    if (b < a) a = b;
}
template<typename T>
void mxr(T &a, const T &b) {
    if (b > a) a = b;
}

class SegmentTree {
private:
    vector <int> d;
    int n;

    void upd(int i) {
        d[i] = max(d[2 * i], d[2 * i + 1]);
    }

    void spusk(int ql, int qr, int l, int r, int i, vector <int>& sp) {
        if (ql >= r || l >= qr) {
            return;
        }
        if (l >= ql && r <= qr) {
            sp.push_back(i);
            return;
        }
        int m = (l + r) / 2;
        spusk(ql, qr, l, m, 2 * i, sp);
        spusk(ql, qr, m, r, 2 * i + 1, sp);
    }

public:
    explicit SegmentTree(const vector <int>& v) {
        n = 1;
        while (n < sz(v)) {
            n <<= 1;
        }
        d.resize(2 * n, -1e9);
        for (int i = 0; i < sz(v); ++i) {
            d[i + n] = v[i];
        }
        for (int i = n - 1; i; --i) {
            upd(i);
        }
    }

    int spusk(int r, int x) {
        vector <int> st;
        spusk(0, r + 1, 0, n, 1, st);
        reverse(all(st));
        for (auto i : st) {
            if (d[i] >= x) {
                int j = i;
                while (j < n) {
                    if (d[2 * j + 1] >= x) {
                        j = 2 * j + 1;
                    } else {
                        j = 2 * j;
                    }
                }
                return j - n;
            }
        }
        return -1;
    }
};

class stmin {
private:
    vector <pii> d;
    int n;

    void upd(int i) {
        d[i] = min(d[2 * i], d[2 * i + 1]);
    }

public:
    explicit stmin(const vector <int>& v) {
        n = 1;
        while (n < sz(v)) {
            n <<= 1;
        }
        d.resize(2 * n, {1e9, 1e9});
        for (int i = 0; i < sz(v); ++i) {
            d[i + n] = {v[i], i};
        }
        for (int i = n - 1; i; --i) {
            upd(i);
        }
    }

    pii get(int l, int r) {
        pii res = pii{1e9, 1e9};
        for (l += n, r += n; l < r; l >>= 1, r >>= 1) {
            if (l & 1) {
                mnr(res, d[l++]);
            }
            if (r & 1) {
                mnr(res, d[--r]);
            }
        }
        return res;
    }
};

signed main() {
    ios_base::sync_with_stdio(false);
#ifdef SYSTY257
    freopen("inputik.txt", "r", stdin);
    freopen("outputik.txt", "w", stdout);
#else
    cin.tie(nullptr);
#endif
    int n, q;
    cin >> n >> q;
    string s;
    cin >> s;
    vector <int> func(n);
    vector <int> bal(n);
    int f = 0;
    for (int i = 0; i < n; ++i) {
        if (s[i] == '(') {
            --f;
        } else {
            ++f;
        }
        bal[i] = -f;
        func[i] = 2 * f - i;
    }
    SegmentTree seg(func);
    stmin stm(bal);
    while (q--) {
        int l, r;
        cin >> l >> r;
        --l, --r;
        int res = 0;
        int c1 = (l ? bal[l - 1] : 0);
        auto [mbal, pos] = stm.get(l, r + 1);
        mbal -= c1;
        int balr = bal[r] - c1;
        if (balr < 0) {
            mbal -= balr;
            res -= balr;
        } else if (balr > 0) {
            res += balr;
        }
        if (mbal >= 0) {
            cout << res << "\n";
            continue;
        }
        int bstp = seg.spusk(pos, -c1 - l + 1);
        if (bstp < l) {
            cout << abs(mbal) * 2 + res << "\n";
        } else {
            cout << bstp - l + 1 + res + 2 * abs(bal[pos] - bal[bstp]) << "\n";
        }
    }
}
